/*
*  Object %name    : %
*  State           :  %state%
*  Creation date   :  Tues Mar 13 12:00:00 2007
*  Last modified   :  %modify_time%
*/
/** @file
*  \brief A tests for ECC
*
*  \version CE2_TST_ECC_2.c#1:csrc:1
*  \author Yermalayeu Ihar
*  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
*           All Rights reserved
*/
/************* Include Files ****************/ 

#include "CE2_TST_ECC_2.h"
#include "CE2_TST_Common.h"
#include <memory.h>

/************************ Defines ************************/
#define TST_FUNC_STRING_LEN 100
#define TST_NO_INTERNAL_KEYGEN 1
#define TST_EXTERNAL_KEYPAIR 1
#define TST_INTERNAL_KG 0
#define CE2_ATP_TST_MSG 10
#define TST_DH_MAX_SECRET_LEN_BYTE 250

/************************ Enums **************************/
/************************ Typedefs ***********************/
/************************ Global Data ********************/

/********************************/
/*  ECDSA SignVerify test data  */
/********************************/
TST_ECC_SignVerifyTestDataStruct TST_ECC_Acceptance_ECDSA_SignVerify_TestData[] =
{
  /*
  typedef struct TST_ECC_TestDataStruct{	
  char					    TST_Name[TST_NAME_STRING_LEN];
  CE2_ECPKI_DomainID_t		TST_CE2_ECPKI_DomainID;
  CE2_ECPKI_HASH_OpMode_t    TST_HashMode;
  DxUint8_t 					TST_input_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];	
  DxUInt32_t                  TST_input_dataSize;
  DxUint8_t                   TST_ExternalPublKey[TST_MAX_ECC_KEY_SIZE_BYTES];
  DxUint32_t                  TST_ExternalPublKeySize;
  DxUint8_t                   TST_ExternalPrivKey[TST_MAX_ECC_KEY_SIZE_BYTES];
  DxUint32_t                  TST_ExternalPrivKeySize;
  DxUint8_t                   TST_output_signiture[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxUInt32_t                  TST_SignitureSize;
  } TST_ECC_TestDataStruct;  
  */
  { 
    {"Acceptance test - ECDSA_SignVerify - secp192r-Key - 48byte data "},
      /*TST_CE2_ECPKI_DomainID*/
      CE2_ECPKI_DomainID_secp192r1,
      /*CE2_ECPKI_HASH_OpMode_t*/
      CE2_ECPKI_HASH_SHA1_mode,
      /*TST_input_data*/
    {0x41,0x1f,0xd6,0xbc,0x3d,0x77,0xd0,0x5f,0xb0,0x71,0x00,0xf6,0x27,0xa7,0x55,0xf8,
    0xb4,0xc7,0x5a,0x31,0xeb,0xce,0x51,0x19,0x94,0x21,0xa6,0xac,0xb8,0xf5,0xbb,0x01,
    0xa8,0xd6,0xfa,0x2b,0x47,0xde,0x8c,0x36,0x04,0x2a,0x32,0x55,0x7c,0xf5,0xde,0x2e},
    /*TST_input_dataSize*/
    48, 
    /*TST_ExternalPublKey*/
    {0x04,
    0x43,0x96,0x40,0x72,0x1a,0x66,0x7c,0xe0,0xa7,0x99,0xbe,0xa3,0x21,0x1a,0xdf,0x7b,
    0xfb,0xe9,0x66,0x23,0xa4,0xbe,0x45,0x90,0x6c,0x57,0x16,0x92,0xa2,0xa7,0x67,0x87,
    0xd9,0x57,0xee,0x3f,0x0c,0x81,0x33,0x33,0x99,0xd7,0xd3,0xd4,0x5f,0xa1,0x61,0x19},
    /*TST_ExternalPublKeySize*/
    49,
    /*TST_ExternalPrivKey*/
    {0xf0,0xac,0xa4,0x26,0x28,0x52,0x83,0xa6,0x8c,0xc3,0x4f,0xe7,0xd8,0x62,0xc6,0x2a,
    0xcb,0x33,0xd1,0x4c,0x34,0x0a,0x7d,0xb9},
    /*TST_ExternalPrivlKeySize*/
    24,
    /*TST_output_signiture*/
    {0},
    /*TST_SignitureSize*/
    48,
  },
  {
    {"Acceptance test - ECDSA_SignVerify - secp224r-Key - 64byte data "},
      /*TST_CE2_ECPKI_DomainID*/
      CE2_ECPKI_DomainID_secp224r1,
      /*CE2_ECPKI_HASH_OpMode_t*/
      CE2_ECPKI_HASH_SHA1_mode,
      /*TST_input_data*/
    {0x0c,0xa6,0x3e,0x72,0x50,0xfc,0x16,0x9d,0xf5,0xd2,0x7e,0xe3,0xe4,0x01,0x3c,0x06,
    0xa7,0x79,0xd2,0x8e,0x71,0x32,0xa2,0x63,0x5e,0x66,0x56,0x9b,0xfb,0xfe,0x7f,0x91,
    0x09,0x4a,0x7c,0x37,0x7e,0xf4,0x9e,0xad,0xcd,0x37,0x8a,0x12,0x67,0x4c,0xde,0x9a,
    0x82,0x25,0x17,0xe0,0x19,0x5e,0xb2,0x7e,0x34,0x71,0x91,0xdc,0x69,0x29,0xa1,0x45},
    /*TST_input_dataSize*/
    64, 
    /*TST_ExternalPublKey*/
    {0x04,
    0x40,0x87,0xa4,0x1a,0x7c,0x75,0xee,0x5e,0x4f,0xcd,0x7a,0xe2,0x40,0x85,0x41,0xab,
    0xaf,0x65,0x01,0xe6,0x9d,0xfb,0x2f,0xaf,0x2b,0x91,0x74,0xa4,0x5a,0x61,0x4b,0x6e,
    0x94,0xdd,0x9f,0x09,0x7c,0x6f,0x79,0x80,0x3c,0x06,0x28,0x52,0x6a,0xe1,0xd8,0x00,
    0x42,0x02,0x90,0xef,0xd5,0x17,0x24,0xa4},
    /*TST_ExternalPublKeySize*/
    57,
    /*TST_ExternalPrivKey*/
    {0xf0,0xac,0xa4,0x26,0x28,0x52,0x83,0xa6,0x8c,0xc3,0x4f,0xe7,0xd8,0x62,0xc6,0x2a,
    0xcb,0x33,0xd1,0x4c,0x34,0x0a,0x7d,0xb9,0xa8,0x9b,0x4d,0x6f},
    /*TST_ExternalPrivlKeySize*/
    28,
    /*TST_output_signiture*/
    {0},
    /*TST_SignitureSize*/
    56,
    },
    {
      {"Acceptance test - ECDSA_SignVerify - secp256r-Key - 128byte data "},
        /*TST_CE2_ECPKI_DomainID*/
        CE2_ECPKI_DomainID_secp256r1,
        /*CE2_ECPKI_HASH_OpMode_t*/
        CE2_ECPKI_HASH_SHA1_mode,
        /*TST_input_data*/
      {0xd4,0xcd,0xa5,0x8a,0x83,0xcd,0xbb,0x42,0xac,0x9f,0xa5,0xa2,0x6e,0xee,0x31,0xd1,
      0xa7,0x3a,0xb1,0x6b,0xcd,0x2a,0xfc,0x79,0x19,0x23,0xb5,0xa0,0xeb,0x19,0xd0,0x98,
      0x6a,0xa5,0x51,0xe0,0x6a,0x58,0x57,0xb0,0x94,0x50,0x5a,0x30,0xc0,0x08,0xb1,0xe7,
      0xa6,0x74,0x57,0x76,0xb6,0x4e,0xee,0x86,0x44,0xab,0x04,0xff,0xe8,0xd1,0x96,0x7a,
      0x25,0x4c,0xd2,0xfa,0x48,0x3f,0x21,0xd6,0x93,0xf9,0x65,0xfa,0x9b,0xc8,0x7f,0x50,
      0xef,0x12,0x15,0x78,0xfa,0xa1,0x92,0xbf,0x2b,0x3f,0x6e,0x4f,0x53,0x83,0xaf,0xa3,
      0x4e,0xea,0xb0,0x3e,0xe5,0x29,0x21,0x9d,0xf3,0xc2,0x4f,0x6a,0xc7,0xd6,0xa5,0xf2,
      0xca,0x3a,0x73,0xd9,0x61,0xcd,0xef,0x0c,0x15,0x08,0x7a,0xf8,0xf2,0xd6,0x24,0xfa},
      /*TST_input_dataSize*/
      128, 
      /*TST_ExternalPublKey*/
      {0x04,
      0x2a,0xe4,0xa3,0xca,0x17,0x5e,0x29,0x90,0xfa,0x1e,0x8b,0x67,0x7d,0x33,0x6b,0x4c,
      0xbc,0xe2,0xd8,0x53,0xd7,0x0f,0x37,0x81,0x86,0xe4,0x5b,0x39,0x0b,0x52,0x3d,0xa7,
      0x09,0xaf,0x5b,0xa5,0x62,0x5e,0x73,0xed,0x88,0x3b,0xe1,0xe7,0xac,0x48,0x30,0x06,
      0xa7,0x0f,0x66,0xad,0xf3,0x1f,0xbb,0xe5,0x89,0x1b,0x4b,0x0d,0xa4,0x6c,0xaa,0x07},
      /*TST_ExternalPublKeySize*/
      65,
      /*TST_ExternalPrivKey*/
      {0xf0,0xac,0xa4,0x26,0x28,0x52,0x83,0xa6,0x8c,0xc3,0x4f,0xe7,0xd8,0x62,0xc6,0x2a,
      0xcb,0x33,0xd1,0x4c,0x34,0x0a,0x7d,0xb9,0xa8,0x9b,0x4d,0x6f,0xa0,0xfa,0xb6,0x38},
      /*TST_ExternalPrivlKeySize*/
      32,
      /*TST_output_signiture*/
      {0},
      /*TST_SignitureSize*/
      64,
    },
    {
      {"Acceptance test - ECDSA_SignVerify - secp384r-Key - 256byte data "},
        /*TST_CE2_ECPKI_DomainID*/
        CE2_ECPKI_DomainID_secp384r1,
        /*CE2_ECPKI_HASH_OpMode_t*/
        CE2_ECPKI_HASH_SHA1_mode,
        /*TST_input_data*/
      {0x28,0xf0,0x82,0x3f,0x1b,0xfe,0xe5,0xac,0x51,0x25,0x4e,0x15,0x6c,0x14,0x02,0xb8,
      0x80,0x1e,0x55,0xad,0x17,0x32,0xcb,0x78,0x79,0x0d,0x7c,0xdb,0x2a,0xae,0xbd,0xee,
      0xb3,0x0a,0xfc,0x71,0xa5,0x02,0xec,0x60,0xdc,0x92,0xe3,0xc8,0x01,0x4b,0x80,0xda,
      0x52,0x03,0x90,0x3d,0xa6,0xcb,0x32,0xa9,0xab,0x21,0x3a,0xb2,0x73,0x67,0xd4,0xe1,
      0x2f,0x94,0x6a,0x09,0x3a,0x2a,0xc7,0xd8,0x59,0x68,0x7c,0xad,0x41,0xc0,0x82,0xa9,
      0x59,0x8b,0x22,0x09,0xc2,0xfc,0x12,0xb3,0x95,0x52,0xe1,0x0e,0x6b,0x52,0x94,0x17,
      0x23,0xf5,0x92,0xb2,0xdf,0x5e,0xbd,0x3d,0x50,0x0e,0xe2,0x6b,0x34,0x5b,0x53,0x50,
      0x1c,0x1e,0xd2,0xb8,0x73,0xad,0xb1,0xbd,0xbc,0x09,0x38,0x99,0x1b,0x58,0x47,0xb8,
      0x17,0x95,0x3c,0x12,0x9e,0x86,0x17,0xb7,0x49,0xee,0xdd,0xab,0xe2,0x05,0x3a,0xf5,
      0x24,0x25,0x69,0xf3,0xc1,0xc6,0x59,0xf0,0xaa,0xac,0x08,0xf8,0x8a,0x5f,0x33,0xeb,
      0x93,0xdc,0x32,0xd1,0x7e,0x8a,0x1e,0x6d,0xcd,0x6f,0x34,0x15,0x54,0xa4,0x7e,0xc1,
      0xf7,0x06,0xb0,0x61,0xb5,0x2f,0x50,0x74,0xe6,0xa5,0x19,0xd6,0xc0,0x50,0xa2,0xd9,
      0x20,0x32,0x3b,0x98,0x88,0x52,0x17,0x88,0x63,0xf9,0xb1,0x50,0x91,0x21,0x68,0xdb,
      0x1f,0x2b,0x6c,0xab,0x56,0xd0,0xde,0x70,0xf8,0x5a,0x33,0xd9,0xc6,0x14,0xda,0xaa,
      0x45,0xff,0x1e,0x0f,0xc2,0xc6,0x4d,0x2f,0x94,0xf4,0x1a,0x05,0xa1,0x65,0x40,0x6b,
      0x24,0xfa,0x68,0x78,0xad,0x91,0x4d,0x0c,0x69,0x35,0x1e,0xa9,0xa3,0x91,0x24,0x85},
      /*TST_input_dataSize*/
      256, 
      /*TST_ExternalPublKey*/
      {0x04,
      0xb9,0x58,0x84,0xa3,0x9a,0x35,0x04,0xae,0x26,0x61,0x97,0xef,0xb5,0xc4,0x9b,0x5d,
      0x56,0xf0,0xe5,0xba,0xd7,0xb2,0xae,0x42,0xfd,0xb0,0x28,0x35,0x62,0x0f,0xec,0xd4,
      0xa3,0x1e,0xcd,0xf0,0x11,0x6f,0x0b,0x2e,0x7d,0x6a,0x28,0xab,0x3e,0x43,0x5e,0xa6,
      0x15,0xb9,0x7b,0xe5,0xaa,0xa7,0x75,0xb5,0x21,0x1c,0xc9,0x48,0x4c,0xd2,0x23,0x28,
      0xe6,0xb7,0x52,0x67,0xfd,0xb1,0x31,0x94,0x61,0x05,0xbe,0xb3,0x71,0xfc,0x41,0x64,
      0xd6,0xad,0xa9,0xba,0xff,0x8f,0xc0,0x15,0x8e,0xe6,0x50,0xb7,0xfe,0x9f,0x74,0x71},
      /*TST_ExternalPublKeySize*/
      97,
      /*TST_ExternalPrivKey*/
      {0xf0,0xac,0xa4,0x26,0x28,0x52,0x83,0xa6,0x8c,0xc3,0x4f,0xe7,0xd8,0x62,0xc6,0x2a,
      0xcb,0x33,0xd1,0x4c,0x34,0x0a,0x7d,0xb9,0xa8,0x9b,0x4d,0x6f,0xa0,0xfa,0xb6,0x38,
      0x77,0x75,0xfd,0xb4,0x4c,0xf5,0xb8,0x52,0x7b,0x1f,0x85,0x13,0xc6,0x78,0xae,0xa7},
      /*TST_ExternalPrivlKeySize*/
      48,
      /*TST_output_signiture*/
      {0},
      /*TST_SignitureSize*/
      96,
      },
      {
        {"Acceptance test - ECDSA_SignVerify - secp521r-Key - 512byte data "},
          /*TST_CE2_ECPKI_DomainID*/
          CE2_ECPKI_DomainID_secp521r1,
          /*CE2_ECPKI_HASH_OpMode_t*/
          CE2_ECPKI_HASH_SHA1_mode,
          /*TST_input_data*/
        {0xf4,0xd0,0x05,0x79,0x91,0xdd,0x6e,0xca,0x3c,0x42,0x50,0x38,0xf7,0x47,0xdd,0x00,
        0x97,0xc0,0xa8,0x35,0x74,0xf0,0xfe,0xc0,0x65,0xa8,0x7a,0xa6,0xec,0xaf,0xd4,0x89,
        0xad,0x66,0xfa,0x72,0x25,0xac,0x62,0xcd,0x98,0x00,0x9e,0xb5,0x4b,0xe5,0x31,0x72,
        0xf4,0x8b,0xa1,0x40,0x6f,0xab,0xcd,0x52,0xb2,0xb3,0x81,0x17,0x03,0x23,0x48,0xbc,
        0x69,0x37,0x81,0xf2,0x60,0xc6,0xb5,0xf1,0xd0,0x6a,0x28,0xbd,0x40,0xe1,0xae,0xa8,
        0x47,0xb3,0xc0,0x18,0x44,0x15,0xcf,0x8a,0x4f,0x0e,0xd8,0xd7,0x70,0xd8,0x39,0xb6,
        0x0e,0x89,0xc3,0x83,0xaa,0xf3,0x10,0x3f,0xcd,0xc8,0x17,0xd7,0x3e,0x02,0xfd,0xa9,
        0x79,0x81,0x2f,0x44,0x5d,0xf6,0xad,0x6f,0x25,0x01,0xa9,0x6e,0x99,0x96,0x50,0x80,
        0x85,0xa5,0xe8,0xac,0x6b,0xfa,0x1b,0xbd,0x75,0x62,0x92,0x8c,0xad,0x0f,0xc6,0x7d,
        0x70,0x3d,0x13,0x4c,0x20,0x16,0x0f,0x0a,0x1a,0xd3,0x19,0x62,0xe8,0x25,0x35,0x21,
        0xb7,0xd3,0x17,0xf6,0x0b,0xa4,0x7d,0x75,0xb1,0x7f,0xc2,0x62,0xf6,0xd1,0xb0,0x2d,
        0x16,0x2f,0x97,0xb9,0xf7,0x3d,0x9b,0x61,0x17,0xce,0x52,0x3d,0xc3,0x4c,0x8f,0xa1,
        0x8b,0x5b,0x78,0xe7,0xf2,0xb9,0xdf,0x6f,0x6a,0x68,0xcf,0xe3,0x7f,0x10,0x64,0xc0,
        0x52,0x9f,0xe0,0x12,0x49,0x32,0xfc,0x7f,0x05,0x38,0x7c,0x86,0x94,0xd4,0x06,0x09,
        0xe8,0x84,0x34,0x09,0x88,0x01,0xe8,0xb2,0x86,0x66,0xe0,0x97,0xb1,0x93,0x8a,0x3e,
        0x0b,0xd4,0x19,0xdf,0x7e,0xbe,0xd8,0x69,0xca,0x5a,0xbe,0xc6,0xc2,0x86,0x43,0x60,
        0xb8,0x97,0x73,0xe4,0x36,0x43,0x41,0x46,0xef,0xbf,0x1d,0x05,0xf4,0x24,0xc9,0xb0,
        0x2b,0x17,0x68,0xa9,0xfe,0xa9,0xd8,0x29,0x50,0x7c,0x41,0x84,0xb5,0x28,0xee,0xae,
        0xe2,0xdc,0x5c,0xfe,0x62,0x49,0x91,0x33,0x8b,0xbb,0xaf,0xb5,0xb1,0x89,0xc9,0x1d,
        0x99,0xb0,0xf5,0xf6,0x30,0xbb,0xa3,0xc5,0x7d,0xe6,0x2d,0x48,0xd5,0x82,0xaf,0xfc,
        0x4e,0x9b,0x18,0xe1,0x76,0xd9,0x81,0x81,0x44,0xa4,0xbe,0x2f,0x4e,0x8b,0x33,0x8d,
        0x3d,0xe7,0xe9,0x51,0x7e,0xbb,0xe2,0x48,0x3b,0xdf,0xa9,0x9b,0x8a,0x5e,0x2c,0x51,
        0xe4,0x1c,0xce,0x15,0xd8,0xbc,0xb9,0x39,0x00,0xc0,0x71,0xfc,0x35,0xf2,0xaf,0x08,
        0xff,0x03,0x6c,0x3f,0x4f,0x73,0x3c,0xb7,0x71,0xb0,0xdd,0x03,0x3c,0x82,0x10,0xb5,
        0x8c,0xa6,0xa7,0x20,0xf2,0xba,0xe0,0x63,0xa9,0x59,0xf1,0xa3,0xcc,0x86,0xe4,0x97,
        0xc7,0x4e,0xa5,0x4a,0x0c,0xa9,0x5a,0x1c,0x07,0xa2,0xf2,0x0a,0x53,0xb7,0x01,0x30,
        0x2e,0x83,0xcb,0x8c,0x2a,0x9a,0x9e,0x05,0x26,0xb5,0x66,0xac,0x7d,0x0f,0x7b,0x41,
        0x7d,0x0e,0xbd,0xf9,0x1b,0x26,0xe3,0x7e,0xe4,0xfb,0x10,0x38,0x37,0xc5,0xa7,0xcb,
        0xb2,0xf9,0x61,0xe1,0xea,0x26,0x9d,0x29,0x5f,0x1c,0xf7,0xa0,0xaf,0x54,0x1b,0x0f,
        0x09,0x8c,0xdc,0xd4,0xe5,0xb2,0x80,0xe6,0xf2,0x03,0x5e,0x14,0x50,0x74,0xac,0x8d,
        0x00,0x51,0x92,0xa5,0x99,0x24,0x82,0xd6,0x3c,0xd8,0xcc,0x05,0xc9,0x1e,0x6d,0x07,
        0x53,0x10,0x28,0x64,0xd2,0x14,0xd9,0x5b,0x18,0x04,0x05,0x26,0x07,0x8c,0xb5,0x7f},
        /*TST_input_dataSize*/
        512, 
        /*TST_ExternalPublKey*/
        {0x04,
        0x00,0xa5,0x1b,0x2f,0x69,0x01,0xd0,0xbc,0xf3,0x31,0xc3,0x6b,0xfe,0xd2,0x1c,0x10,
        0x0e,0x06,0x65,0x4c,0xfe,0xeb,0x79,0x26,0x32,0x27,0xae,0x52,0x7c,0x0f,0x2d,0x5e,
        0x61,0x63,0xde,0x43,0x11,0xdd,0xae,0x04,0xb8,0xa3,0x8b,0x86,0x02,0x49,0x6a,0xa5,
        0xa0,0x29,0x3a,0x39,0xd5,0xd1,0xd9,0x66,0xe4,0xd9,0xcc,0x1b,0xc7,0x72,0xa1,0x85,
        0xd1,0x1e,0x00,0x7c,0x58,0x83,0x1b,0x20,0xb6,0xdc,0xd4,0xed,0x7d,0x5c,0x57,0x02,
        0xaa,0x48,0xb2,0xd4,0xf8,0x8c,0x22,0xdf,0x66,0xe4,0x21,0x92,0x45,0x7c,0xe5,0x77,
        0x04,0x26,0xb8,0xf1,0x49,0xa4,0x03,0x23,0x7c,0xe5,0xd7,0x4e,0xbf,0xc4,0x8b,0xee,
        0xd0,0xfa,0xba,0xf3,0x02,0xb8,0xb8,0x33,0x80,0x70,0x37,0xa0,0xfb,0x7b,0xd9,0x19,
        0x4d,0xfd,0xc9,0xd0},
        /*TST_ExternalPublKeySize*/
        133,
        /*TST_ExternalPrivKey*/
        {0xf0,0xac,0xa4,0x26,0x28,0x52,0x83,0xa6,0x8c,0xc3,0x4f,0xe7,0xd8,0x62,0xc6,0x2a,
        0xcb,0x33,0xd1,0x4c,0x34,0x0a,0x7d,0xb9,0xa8,0x9b,0x4d,0x6f,0xa0,0xfa,0xb6,0x38,
        0x77,0x75,0xfd,0xb4,0x4c,0xf5,0xb8,0x52,0x7b,0x1f,0x85,0x13,0xc6,0x78,0xae,0xa7,
        0x6f,0x1a,0xd4,0x08,0xdc,0xa2,0xbb,0x9a,0x02,0x78,0x34,0xd4,0x54,0x21,0x03,0x30,
        0x71},
        /*TST_ExternalPrivlKeySize*/
        65,
        /*TST_output_signiture*/
        {0},
        /*TST_SignitureSize*/
        132,
      },
};

/**********************/
/*  ECC DH test data  */
/**********************/
TST_ECC_DH_TestDataStruct  TST_ECC_Acceptance_DH_TestData[] =
{
  /*
  typedef struct TST_ECC_DH_TestDataStruct{	
  char					    TST_Name[TST_NAME_STRING_LEN];
  CE2_ECPKI_DomainID_t		TST_CE2_ECPKI_DomainID;
  DxUint8_t                   TST_ExternalPublKey1[TST_MAX_ECC_KEY_SIZE_BYTES];
  DxUint32_t                  TST_ExternalPublKey1Size;
  DxUint8_t                   TST_ExternalPrivKey1[TST_MAX_ECC_KEY_SIZE_BYTES];
  DxUint32_t                  TST_ExternalPrivKey1Size;
  DxUint8_t                   TST_ExternalPublKey2[TST_MAX_ECC_KEY_SIZE_BYTES];
  DxUint32_t                  TST_ExternalPublKey2Size;
  DxUint8_t                   TST_ExternalPrivKey2[TST_MAX_ECC_KEY_SIZE_BYTES];
  DxUint32_t                  TST_ExternalPrivKey2Size;
  } TST_ECC_DH_TestDataStruct;  
  */
  { 
    {"Acceptance test - ECC-DH DomainID_secp192r1"},
      /*TST_CE2_ECPKI_DomainID*/
      CE2_ECPKI_DomainID_secp192r1,
      /*TST_ExternalPublKey1*/
    {0x04,
    0xad,0x41,0x02,0x31,0x0e,0x44,0xee,0x09,0x38,0x33,0xc6,0x98,0x00,0x80,0x55,0xac,
    0xc6,0xb4,0xe8,0xad,0x4c,0xf2,0x63,0xf8,0x09,0x4a,0xd3,0x9c,0x37,0x6c,0xe0,0xc5,
    0xb7,0x1c,0x51,0xc1,0x54,0x8d,0x1d,0x86,0x73,0x93,0x1c,0x83,0xb9,0x80,0x2c,0xe6},
    /*TST_ExternalPublKey1Size*/
    49,
    /*TST_ExternalPrivKey1*/
    {0xec,0x27,0xd0,0x97,0xb3,0x7a,0xe5,0xaf,0xb7,0x9d,0xb8,0xde,0x41,0xa9,0x9f,0xb3,
    0x87,0x28,0xda,0x8b,0x1c,0x99,0xac,0xb6},
    /*TST_ExternalPrivKey1Size*/
    24,
    /*TST_ExternalPublKey2*/
    {0x04,
    0x44,0xaa,0x36,0xa2,0x5b,0xc3,0xdd,0xe6,0x28,0x8a,0x32,0x55,0xc7,0x1a,0x51,0x32,
    0x9e,0x42,0xaa,0x04,0x03,0x54,0x3b,0x10,0x53,0xec,0xef,0x1d,0x5d,0x71,0x43,0x45,
    0x3b,0x86,0xc2,0xf3,0x50,0xb6,0xc3,0xbd,0x4d,0xa7,0x70,0x7f,0x48,0xcc,0x37,0x10},
    /*TST_ExternalPublKey2Size*/
    49,
    /*TST_ExternalPrivKey2*/
    {0xcc,0x61,0x3b,0x0b,0xea,0xc9,0x8e,0x15,0xc8,0x42,0x02,0xd9,0x9f,0xfc,0xf8,0x48,
    0xb9,0x21,0xdb,0x35,0xc0,0xbb,0x5b,0xa2},
    /*TST_ExternalPrivKey2Size*/
    24,
  },
  { 
    {"Acceptance test - ECC-DH DomainID_secp224r1"},
      /*TST_CE2_ECPKI_DomainID*/
      CE2_ECPKI_DomainID_secp224r1,
      /*TST_ExternalPublKey1*/
    {0x04,
    0x52,0x54,0xce,0x14,0x3c,0x02,0x5b,0x14,0x0d,0xd9,0x94,0xfd,0x25,0xaa,0x31,0x36,
    0xe9,0x2f,0x39,0xd0,0x2f,0xe0,0x4f,0x3e,0x45,0x5a,0x1f,0xa2,0xb2,0xda,0xc0,0x26,
    0x0b,0x27,0x45,0xdb,0xcc,0xfd,0x3c,0xb7,0xb6,0xca,0xc7,0x91,0xf2,0x27,0xf6,0xc9,
    0x0c,0xd1,0x1d,0x26,0x29,0x22,0x92,0x2f},
    /*TST_ExternalPublKey1Size*/
    57,
    /*TST_ExternalPrivKey1*/
    {0x81,0x8a,0xd9,0x2a,0x73,0xbb,0xa7,0xe8,0xc3,0xfb,0xb8,0x66,0x8c,0xc1,0xf9,0xc5,
    0xcd,0xf3,0xa8,0x26,0xd7,0x86,0x3d,0x85,0xe5,0xc0,0x86,0x2c},
    /*TST_ExternalPrivKey1Size*/
    28,
    /*TST_ExternalPublKey2*/
    {0x04,
    0x61,0x80,0x7a,0x2c,0x2a,0xb8,0x33,0xf8,0xe5,0x69,0x3a,0x28,0x45,0x61,0x17,0x2e,
    0xec,0x89,0x65,0xb6,0x11,0xb0,0x2a,0xf2,0xfc,0xa1,0xe8,0x35,0x0d,0xbd,0x58,0x3f,
    0x66,0xed,0xec,0xa1,0x80,0x25,0x3f,0xc2,0x5e,0xef,0xa9,0x9c,0xcd,0xeb,0x79,0x40,
    0x23,0x63,0xe3,0x5f,0xaf,0x36,0x3f,0xc6},
    /*TST_ExternalPublKey2Size*/
    57,
    /*TST_ExternalPrivKey2*/
    {0xd5,0xec,0x5d,0xed,0x8f,0xc4,0xdd,0x82,0x74,0x26,0x62,0xcc,0x60,0x68,0x22,0xd0,
    0x1a,0x27,0x57,0x21,0xb8,0xa0,0xcf,0x78,0x0f,0x9c,0xd0,0x36},
    /*TST_ExternalPrivKey2Size*/
    28,
    },
    { 
      {"Acceptance test - ECC-DH DomainID_secp256r1"},
        /*TST_CE2_ECPKI_DomainID*/
        CE2_ECPKI_DomainID_secp256r1,
        /*TST_ExternalPublKey1*/
      {0x04,
      0x4e,0x70,0x81,0xa8,0x89,0xb6,0x26,0x9e,0xd6,0xad,0xa9,0xa2,0x5a,0xa4,0x9b,0x9f,
      0x47,0x85,0x01,0x53,0xe3,0x41,0xdb,0xa9,0xa1,0x9f,0xfa,0xbe,0xe0,0xf7,0xe6,0x50,
      0xcb,0x2a,0x00,0x0a,0x54,0x21,0x70,0x4b,0x6c,0xfb,0x79,0xe1,0xe3,0x0f,0xc7,0x23,
      0xf3,0x00,0x4a,0x12,0x7e,0xa8,0x5b,0xb9,0xd1,0x9e,0x46,0x75,0xf7,0x06,0xb0,0x2f},
      /*TST_ExternalPublKey1Size*/
      65,
      /*TST_ExternalPrivKey1*/
      {0x3e,0xa3,0x6f,0x17,0xa6,0x1a,0x2b,0xeb,0xff,0xba,0x58,0x3d,0xb5,0x9a,0x0c,0xd0,
      0x0a,0xff,0x50,0x25,0xab,0xbc,0xdb,0x6b,0x1b,0xe8,0x2c,0xe4,0x51,0xcf,0x3c,0x9b},
      /*TST_ExternalPrivKey1Size*/
      32,
      /*TST_ExternalPublKey2*/
      {0x04,
      0x09,0x59,0x82,0xfc,0x5f,0xa8,0x2a,0x0d,0x19,0x3e,0x64,0x72,0x61,0x8d,0x9a,0x78,
      0x45,0x44,0x7f,0xdc,0x72,0x19,0xca,0x5f,0x0a,0x6b,0xfd,0x60,0xb2,0x10,0x2d,0xd8,
      0x5a,0x3a,0x0c,0xdb,0xb3,0xf1,0x2b,0xf2,0x40,0x5c,0xa4,0x3c,0x00,0xdf,0xc5,0x8a,
      0xa6,0x80,0x60,0x73,0x0b,0xee,0xe7,0x73,0xeb,0x79,0xd5,0x16,0xbb,0xc0,0x61,0x6c},
      /*TST_ExternalPublKey2Size*/
      65,
      /*TST_ExternalPrivKey2*/
      {0x53,0x98,0xdb,0xf1,0x28,0xce,0xc4,0xb3,0x79,0x9b,0x56,0x17,0xa8,0xac,0xf2,0x76,
      0x83,0x66,0xf9,0x21,0x15,0x2f,0x4b,0x4d,0xb2,0x5b,0x1d,0x24,0xcc,0x37,0xde,0x13},
      /*TST_ExternalPrivKey2Size*/
      32,
    },
    { 
      {"Acceptance test - ECC-DH DomainID_secp384r1"},
        /*TST_CE2_ECPKI_DomainID*/
        CE2_ECPKI_DomainID_secp384r1,
        /*TST_ExternalPublKey1*/
      {0x04,
      0x86,0xd0,0x39,0xe9,0xaa,0xa6,0x81,0xf1,0xfe,0x0a,0xf2,0x85,0x74,0x93,0x3a,0xd9,
      0xb6,0x6a,0xe2,0x16,0xa2,0xc6,0x00,0xe4,0x10,0xec,0x0b,0xb9,0xa0,0x0f,0xe9,0x48,
      0xe1,0x89,0x55,0x04,0x5c,0x4f,0xa4,0xd4,0x3f,0xb3,0xa8,0xeb,0xc8,0xc2,0x3a,0xa4,
      0x09,0x30,0xae,0xe5,0x06,0xae,0x36,0x19,0x5f,0x40,0xe1,0x2e,0x0c,0x53,0x3b,0x6c,
      0xa6,0x2c,0x3f,0xb0,0x11,0x7a,0x33,0x66,0xd0,0xcc,0x22,0xaa,0xf1,0x4d,0x27,0x04,
      0x70,0xa7,0x2c,0x91,0xfe,0xcc,0x9b,0x9b,0xda,0xa8,0xa2,0xbc,0xd8,0x7a,0x98,0x31},
      /*TST_ExternalPublKey1Size*/
      97,
      /*TST_ExternalPrivKey1*/
      {0x08,0xb7,0x3a,0x32,0x62,0xe9,0x44,0x01,0x6a,0xe3,0x2e,0xa2,0xc6,0xf7,0x82,0x60,
      0x18,0xf9,0xc7,0xcc,0xb8,0x5b,0x06,0xde,0x9e,0x19,0x21,0xbe,0x0a,0xf7,0x4b,0x28,
      0x9f,0x01,0x19,0x89,0xef,0xd8,0x2c,0x08,0x78,0x4c,0x3e,0x4b,0x14,0xae,0x61,0x27},
      /*TST_ExternalPrivKey1Size*/
      48,
      /*TST_ExternalPublKey2*/
      {0x04,
      0x60,0xc1,0x41,0x29,0x74,0x67,0x24,0x67,0x2c,0x06,0x4e,0x0d,0x17,0x99,0x67,0x7c,
      0xf3,0x37,0x6d,0x00,0x78,0x91,0x4f,0xce,0xf4,0xab,0x81,0xac,0x67,0x6f,0x63,0x45,
      0x38,0x1a,0x7d,0xa6,0xa3,0xeb,0xcd,0x7e,0x77,0xef,0x8f,0x8f,0xf6,0xc3,0x6f,0x3d,
      0x42,0x92,0x88,0x75,0xb9,0xe0,0x8c,0x4e,0xec,0x04,0x6d,0x1e,0xde,0x45,0x43,0x0f,
      0x4c,0xaf,0x84,0xfe,0xfc,0x97,0x68,0xfa,0x18,0xbf,0x93,0x0d,0xa6,0xb1,0xbf,0x74,
      0x4e,0xc3,0x3e,0xb2,0x96,0x67,0x20,0xb8,0x55,0x3f,0x95,0x3f,0x52,0xb9,0x32,0x18},
      /*TST_ExternalPublKey2Size*/
      97,
      /*TST_ExternalPrivKey2*/
      {0x95,0x57,0xb8,0x78,0x2d,0xc7,0x77,0xf3,0xff,0x78,0x5b,0x9f,0xff,0xe4,0x20,0x77,
      0x55,0xd0,0xdc,0x4b,0xb2,0xce,0x37,0xb8,0x01,0x4a,0x02,0xea,0x13,0xa6,0xf9,0x88,
      0x74,0xe5,0xa3,0xf5,0xf7,0xd7,0xf0,0xf1,0xa6,0x44,0xb2,0x21,0x10,0x06,0xfc,0xfc},
      /*TST_ExternalPrivKey2Size*/
      48,
      },
      { 
        {"Acceptance test - ECC-DH DomainID_secp521r1"},
          /*TST_CE2_ECPKI_DomainID*/
          CE2_ECPKI_DomainID_secp521r1,
          /*TST_ExternalPublKey1*/
        {0x04,
        0x01,0x97,0xb8,0x6b,0x1b,0x7d,0xa3,0xb9,0x44,0x51,0xa2,0xfc,0x6c,0x77,0xae,0x65,
        0x24,0xfd,0x3d,0xdb,0xa9,0x43,0x4f,0x79,0x66,0x5a,0xb1,0x4c,0x8e,0xa9,0xb3,0x88,
        0x6f,0xf3,0x5a,0x96,0xb4,0x92,0xb4,0xa2,0x06,0xbf,0x19,0x52,0x87,0x7a,0xff,0xff,
        0x31,0xe3,0x4e,0x10,0x2b,0x19,0x35,0x16,0x28,0xb6,0xd5,0x19,0xc9,0x7c,0x3d,0xf8,
        0x86,0x22,0x00,0x5e,0x40,0x8b,0x7c,0xe0,0xc3,0x26,0xea,0x94,0x2b,0xbe,0x79,0xe6,0x22,
        0x1e,0x9a,0x5b,0x62,0x97,0xc6,0xa2,0x69,0xab,0xd1,0x1e,0xe3,0xd2,0xc2,0x4e,0x4a,
        0x1a,0xc3,0xa3,0x74,0x12,0x0f,0x5c,0x32,0x05,0xae,0x10,0x6a,0xb7,0xe2,0x76,0x09,
        0xdd,0x69,0xd0,0x99,0xd7,0x2f,0x85,0xd5,0x9f,0x41,0x31,0x1c,0xa2,0x70,0x3a,0xa8,
        0x21,0xa7,0x6a},
        /*TST_ExternalPublKey1Size*/
        133,
        /*TST_ExternalPrivKey1*/
        {0x49,0xe4,0xed,0x27,0xdc,0x7a,0x6c,0x55,0xa3,0xb5,0xc4,0x12,0x51,0xdb,0x4d,0x21,
        0xd8,0x7d,0x69,0x6e,0xc6,0xc3,0xd4,0x2a,0xfc,0xf6,0xc8,0x1f,0xbe,0x46,0x99,0x2d,
        0x91,0x37,0x7b,0x7e,0xef,0x25,0x28,0xf4,0x35,0x84,0x9e,0xfb,0x7b,0x0e,0x44,0x0d,
        0x52,0x9b,0x8b,0x2f,0x9f,0xc5,0x01,0x40,0xc3,0xf6,0x2f,0x8b,0xa8,0x64,0xfa,0x47,
        0x0e},
        /*TST_ExternalPrivKey1Size*/
        65,
        /*TST_ExternalPublKey2*/
        {0x04,
        0x00,0xee,0x77,0xf4,0x37,0x72,0x1e,0x0d,0xf3,0x5d,0x20,0xb1,0xe5,0xbe,0xb9,0x1f,
        0x86,0xb1,0x82,0x93,0x20,0x20,0x2d,0x5d,0x6a,0x7b,0x7a,0x36,0x19,0xe8,0xf3,0xba,
        0x30,0xc8,0x45,0x76,0x03,0xf7,0xa0,0xa9,0x26,0x36,0x85,0x9c,0x0f,0xee,0x99,0xfb,
        0x32,0xbc,0xdd,0x13,0xf5,0xdc,0x53,0xa9,0x16,0x81,0x69,0xff,0x9c,0xc4,0x39,0x79,
        0xd2,0x19,0x00,0x4f,0xce,0x2f,0xd3,0x4f,0xf5,0x08,0x92,0x5a,0x95,0x15,0x9a,0x57,0x35,
        0x54,0x96,0x50,0xc5,0xcd,0x79,0xcd,0x3c,0x7d,0x6b,0x38,0x8c,0x66,0x66,0x82,0x3a,
        0xb2,0xdb,0xb6,0xa5,0x87,0x29,0x4a,0x78,0xaa,0x92,0x30,0x1e,0x8c,0x72,0x7a,0xab,
        0xc1,0x6e,0xad,0x24,0x38,0x5c,0x1c,0xda,0x6e,0x82,0x8a,0x59,0x13,0x84,0xb4,0xe4,
        0xbe,0xa5,0x37},
        /*TST_ExternalPublKey2Size*/
        133,
        /*TST_ExternalPrivKey2*/
        {0x2e,0x22,0x9b,0x00,0xdd,0x11,0x7b,0x07,0x75,0xc0,0x86,0xa9,0xe2,0xa2,0x04,0xb4,
        0x31,0x14,0x22,0x2c,0x70,0xf3,0x7e,0xed,0x18,0xd4,0xc0,0xe6,0xde,0x60,0x3f,0xbc,
        0xba,0xdb,0x49,0x1c,0xc7,0x01,0x87,0x46,0x33,0xa0,0x9a,0x31,0x4a,0x11,0xfd,0xb6,
        0x87,0x6d,0x97,0x5c,0x23,0xea,0xbf,0xc4,0xe7,0xf7,0x13,0x98,0xb7,0xd5,0x56,0xc5,
        0x74},
        /*TST_ExternalPrivKey2Size*/
        65,
      },
};

/***************************************/
/*  ElGamal Encrypt Decrypt test data  */
/***************************************/
TST_ECC_EncDecTestDataStruct TST_ECC_Acceptance_ElGamal_EncDec_TestData[] =
{
  /*
  char					    TST_Name[TST_NAME_STRING_LEN];
  CE2_ECPKI_DomainID_t		TST_CE2_ECPKI_DomainID;
  DxUint8_t 					TST_input_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];	
  DxUint32_t                  TST_input_dataSize;
  DxUint8_t                   TST_ExternalPublKey[TST_MAX_ECC_KEY_SIZE_BYTES];
  DxUint32_t                  TST_ExternalPublKeySize;
  DxUint8_t                   TST_ExternalPrivKey[TST_MAX_ECC_KEY_SIZE_BYTES];
  DxUint32_t                  TST_ExternalPrivKeySize;
  DxUint8_t                   TST_output_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxUint32_t                  TST_output_dataSize;
  DxUint8_t                   TST_Decrypted_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxUint32_t                  TST_Decrypted_dataSize;
  */
  { 
    {"Acceptance test - ElGamal EncryptDecrypt secp192r-Key - 23byte data "},
      /*TST_CE2_ECPKI_DomainID*/
      CE2_ECPKI_DomainID_secp192r1,
      /*TST_input_data*/
    {0xec,0xca,0x8d,0x21,0xfa,0x20,0x4d,0xdc,0x1b,0x04,0x07,0xb9,0xa6,0x46,0xdd,0xa3,
    0xe3,0xd9,0x85,0xc6,0x65,0xd7,0x43},
    /*TST_input_dataSize*/
    23, 
    /*TST_ExternalPublKey*/
    {0x04,
    0xb8,0x13,0x76,0x81,0x0d,0x91,0xe6,0x0b,0xe7,0x4e,0x52,0xf6,0x67,0x3d,0x0d,
    0x21,0x38,0x9a,0x12,0xae,0x08,0x40,0xae,0x38,0x0e,0x6d,0xf9,0xda,0xe8,0xae,0xcd,
    0x4b,0x90,0x3e,0xd5,0xfd,0x8f,0xb7,0x37,0x80,0xdb,0xfe,0x90,0x97,0x03,0x48,0x77,
    0x7d},
    /*TST_ExternalPublKeySize*/
    49,
    /*TST_ExternalPrivKey*/
    {0xd8,0xc1,0x73,0x2c,0x26,0x96,0x33,0xe0,0xbe,0x2d,0x26,0x60,0x82,0x16,0x80,
    0x5d,0x94,0x9c,0xed,0x04,0x9f,0xf5,0x8f,0x5d},
    /*TST_ExternalPrivKeySize*/
    24,
    /*TST_output_data*/
    {0},
    /*TST_output_dataSize*/
    96,
    /*TST_Decrypted_data*/
    {0},
    /*TST_output_dataSize*/
    1000,/*23*/
  },
  { 
    {"Acceptance test - ElGamal EncryptDecrypt secp224r-Key - 27byte data  "},
      /*TST_CE2_ECPKI_DomainID*/
      CE2_ECPKI_DomainID_secp224r1,
      /*TST_input_data*/
    {0x76,0xb1,0xe8,0xfd,0x42,0xd6,0x22,0x96,0xe4,0xea,0x3d,0x84,0x9c,0x7a,0x9f,0x67,
    0x1a,0xca,0x8c,0x3f,0xef,0x78,0x40,0x2e,0x42,0x5d,0x3b},
    /*TST_input_dataSize*/
    27, 
    /*TST_ExternalPublKey*/
    {0x04,
    0xa1,0x62,0x6a,0x86,0x23,0xe1,0x64,0xc6,0x69,0x3d,0x2c,0xee,0xf2,0x8d,0x7a,
    0xa9,0xca,0x25,0xdd,0xf4,0xde,0x94,0xd8,0x9c,0x6f,0x95,0x45,0x2b,0x97,0x52,
    0xe2,0x1d,0x4a,0x73,0xc6,0x01,0x5a,0xd0,0xd4,0x40,0x9c,0x0d,0x77,0xcf,0x2f,
    0xc3,0x24,0xa5,0xac,0x40,0xa0,0xa5,0x1c,0x52,0x9a,0x46},
    /*TST_ExternalPublKeySize*/
    57,
    /*TST_ExternalPrivKey*/
    {0xd8,0xc1,0x73,0x2c,0x26,0x96,0x33,0xe0,0xbe,0x2d,0x26,0x60,0x82,0x16,0x80,
    0x5d,0x94,0x9c,0xed,0x04,0x9f,0xf5,0x8f,0x5d,0xbf,0x7d,0x8c,0x65},
    /*TST_ExternalPrivKeySize*/
    28,
    /*TST_output_data*/
    {0},
    /*TST_output_dataSize*/
    112, 
    /*TST_Decrypted_data*/
    {0},
    /*TST_output_dataSize*/
    1000,/*27*/ 
    },
    { 
      {"Acceptance test - ElGamal EncryptDecrypt secp256r-Key - 31byte data "},
        /*TST_CE2_ECPKI_DomainID*/
        CE2_ECPKI_DomainID_secp256r1,
        /*TST_input_data*/
      {0xa1,0xd1,0x45,0xcf,0xac,0x15,0x8b,0x04,0x3b,0x26,0x62,0xa8,0x17,0x78,0xf7,0x81,
      0x01,0x9a,0x34,0x26,0x46,0x74,0xee,0x61,0x93,0xcd,0x60,0xd8,0x0b,0x10,0xd8},
      /*TST_input_dataSize*/
      31, 
      /*TST_ExternalPublKey*/
      {0x04,
      0x2a,0xe4,0xa3,0xca,0x17,0x5e,0x29,0x90,0xfa,0x1e,0x8b,0x67,0x7d,0x33,0x6b,0x4c,
      0xbc,0xe2,0xd8,0x53,0xd7,0x0f,0x37,0x81,0x86,0xe4,0x5b,0x39,0x0b,0x52,0x3d,0xa7,
      0x09,0xaf,0x5b,0xa5,0x62,0x5e,0x73,0xed,0x88,0x3b,0xe1,0xe7,0xac,0x48,0x30,0x06,
      0xa7,0x0f,0x66,0xad,0xf3,0x1f,0xbb,0xe5,0x89,0x1b,0x4b,0x0d,0xa4,0x6c,0xaa,0x07},
      /*TST_ExternalPublKeySize*/
      65,
      /*TST_ExternalPrivKey*/
      {0xf0,0xac,0xa4,0x26,0x28,0x52,0x83,0xa6,0x8c,0xc3,0x4f,0xe7,0xd8,0x62,0xc6,
      0x2a,0xcb,0x33,0xd1,0x4c,0x34,0x0a,0x7d,0xb9,0xa8,0x9b,0x4d,0x6f,0xa0,0xfa,0xb6,
      0x38},
      /*TST_ExternalPrivKeySize*/
      32,
      /*TST_output_data*/
      {0},
      /*TST_output_dataSize*/
      128, /*48*/
      /*TST_Decrypted_data*/
      {0},
      /*TST_output_dataSize*/
      1000,/*31*/ 
    },
    { 
      {"Acceptance test - ElGamal EncryptDecrypt secp384r-Key - 47byte data "},
        /*TST_CE2_ECPKI_DomainID*/
        CE2_ECPKI_DomainID_secp384r1,
        /*TST_input_data*/
      {0x88,0xd9,0xa3,0x41,0xe7,0x27,0xbb,0x33,0x9f,0x8e,0x18,0xa3,0xfa,0xc2,0xf2,0xfb,
      0x85,0xab,0xdc,0x8f,0x13,0x5d,0xeb,0x30,0x05,0x4a,0x1a,0xfd,0xc9,0xb6,0xed,0x7d,
      0xa1,0x6c,0x55,0xeb,0xa6,0xb0,0xd4,0xd1,0x0c,0x74,0xe1,0xd9,0xa7,0xcf,0x8e},
      /*TST_input_dataSize*/
      47, 
      /*TST_ExternalPublKey*/
      {0x04,
      0xd1,0x30,0x07,0x87,0x84,0x4c,0x85,0x27,0xfa,0x2d,0xf3,0xfd,0x7f,0x51,0x4f,0xa9,
      0xf5,0x6b,0x78,0xfe,0x93,0x5c,0x68,0x7c,0x9e,0x7c,0xe1,0xbc,0xa7,0x95,0xb9,0xeb,
      0xc5,0x14,0x77,0x1b,0x65,0x30,0x18,0x27,0xbd,0x27,0x5e,0x7c,0xcc,0xe0,0x59,0xf4,
      0x62,0x3b,0x1a,0x20,0xe0,0x05,0x1e,0xe6,0x77,0x63,0x97,0x76,0xd0,0x86,0xb1,0x74,
      0xa2,0x57,0x45,0x4c,0xa5,0xef,0xab,0xf7,0xca,0xb9,0x9f,0xdb,0x33,0x66,0x28,0xb2,
      0x04,0x7f,0x16,0x0a,0x59,0xb8,0x41,0x05,0x2e,0x3f,0x78,0x7b,0xfd,0x50,0x46,0x30},
      /*TST_ExternalPublKeySize*/
      97,
      /*TST_ExternalPrivKey*/
      {0xd8,0xc1,0x73,0x2c,0x26,0x96,0x33,0xe0,0xbe,0x2d,0x26,0x60,0x82,0x16,0x80,0x5d,
      0x94,0x9c,0xed,0x04,0x9f,0xf5,0x8f,0x5d,0xbf,0x7d,0x8c,0x65,0x81,0xbe,0xa1,0xf3,
      0x12,0x8e,0xdd,0xe9,0xaa,0xd2,0xd3,0x86,0x6b,0x26,0xc3,0x3d,0x72,0x12,0x52,0xc2},         
      /*TST_ExternalPrivKeySize*/
      48,
      /*TST_output_data*/
      {0},
      /*TST_output_dataSize*/
      192, /*48*/
      /*TST_Decrypted_data*/
      {0},
      /*TST_output_dataSize*/
      1000,/*47*/
      },
      { 
        {"Acceptance test - ElGamal EncryptDecrypt secp521r-Key - 63byte data "},
          /*TST_CE2_ECPKI_DomainID*/
          CE2_ECPKI_DomainID_secp521r1,
          /*TST_input_data*/
        {0x1d,0xa0,0x02,0x4c,0x89,0x35,0xff,0x67,0x4b,0xfb,0xc8,0xf8,0x12,0x76,0x24,0xbd,
        0x75,0x73,0xfa,0x11,0x35,0x3e,0xb7,0xbf,0xc2,0x16,0xf0,0x14,0x01,0xde,0x49,0x38,
        0x4d,0x15,0x95,0xbe,0xbc,0x08,0x3e,0x79,0xa3,0x46,0xe7,0x91,0x5c,0x55,0x51,0xd7,
        0x46,0xa3,0x7b,0x56,0x0e,0xbf,0x0e,0x2a,0x2d,0xc9,0xf7,0x96,0xb2,0x28,0x56,0x50,
        },//0x11}, //modulus size - 2
        /*TST_input_dataSize*/
        64,//65, //modulus size - 2
        /*TST_ExternalPublKey*/
        {0x04,
        0x00,0x46,0xe3,0x1d,0x63,0x0c,0xe3,0x98,0xa7,0xfd,0x03,0xc9,0x4f,0x61,0x77,0xbe,
        0x37,0x85,0x94,0x0f,0x73,0x4a,0xf1,0x62,0x13,0x46,0x58,0x15,0x4a,0x4a,0xf5,0x49,
        0x8c,0x2a,0x24,0x53,0xc4,0xda,0x1a,0xe3,0x15,0x10,0x86,0x07,0xc3,0xd8,0xd3,0xde,
        0x5b,0xdb,0x83,0xf5,0x0e,0x3f,0x29,0x77,0x2c,0x7c,0x80,0x3d,0x4d,0x7c,0x1d,0x9f,
        0xdc,0x2a,0x01,0x17,0x39,0x9d,0xb3,0x7a,0x4a,0x41,0x10,0xfb,0x45,0x2a,0x67,0xbc,
        0x0c,0x6f,0x84,0x41,0xcd,0x52,0xf3,0xae,0x46,0xaa,0x69,0x14,0x94,0xc4,0xa8,0x19,
        0x20,0xc3,0x5b,0xe9,0x84,0x67,0x5f,0x0e,0xde,0x40,0xe5,0x74,0x4d,0x7a,0x68,0xfb,
        0x6d,0xf7,0x49,0x4a,0xf6,0xed,0xd0,0x2b,0x5c,0x28,0x1b,0x34,0xd9,0x5f,0x5b,0xbe,
        0xa5,0x84,0x59,0xcf},
        /*TST_ExternalPublKeySize*/
        133,
        /*TST_ExternalPrivKey*/
        {0xd8,0xc1,0x73,0x2c,0x26,0x96,0x33,0xe0,0xbe,0x2d,0x26,0x60,0x82,0x16,0x80,
        0x5d,0x94,0x9c,0xed,0x04,0x9f,0xf5,0x8f,0x5d,0xbf,0x7d,0x8c,0x65,0x81,0xbe,0xa1,
        0xf3,0x12,0x8e,0xdd,0xe9,0xaa,0xd2,0xd3,0x86,0x6b,0x26,0xc3,0x3d,0x72,0x12,0x52,
        0xc2,0x1d,0xba,0x3f,0x98,0x73,0xd6,0xbc,0x69,0x37,0x50,0x39,0x80,0x4f,0x57,0xb1,
        0xe4,0xa4},
        /*TST_ExternalPrivKeySize*/
        65,
        /*TST_output_data*/
        {0},
        /*TST_output_dataSize*/
        264, /*48*/
        /*TST_Decrypted_data*/
        {0},
        /*TST_output_dataSize*/
        1000,/*65*/
      },
};

int TST_NumberOf_ECC_SignVerifyAcceptanceTests = sizeof(TST_ECC_Acceptance_ECDSA_SignVerify_TestData)/sizeof(TST_ECC_Acceptance_ECDSA_SignVerify_TestData[0]);
int TST_NumberOf_ECC_DHAcceptanceTests = sizeof(TST_ECC_Acceptance_DH_TestData)/sizeof(TST_ECC_Acceptance_DH_TestData[0]);
int TST_NumberOf_ECC_ElGamalAcceptanceTests = sizeof(TST_ECC_Acceptance_ElGamal_EncDec_TestData)/sizeof(TST_ECC_Acceptance_ElGamal_EncDec_TestData[0]);

/************* Private function prototype ****************/
/************************ Private Functions **************/
/************************ Public Functions ***************/

/*********************************************************
* Function Name:                                                           
*  CE2_ATP_TST_ECC_Acceptance_ECDSA_IntegratedSignVerify        
* 
* Inputs:
*  None
*
* Outputs:
*  CE2Error_t - Function error return                                     
*                                
*
* Description:                                                                 
*  This function Is a Acceptance test for ECC ESDSA Sign & Verify                   
*  This function Signs & Verifies known vectors 
* Algorithm:       
*  1. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key 
*     b. Build the Public Key 
*  2. Call CE2_ECDSA_Sign to perform the sign operation
*  3. Call CE2_ECDSA_Verify to perform the verification operation   
*
******************************************************************************/                                          
CE2Error_t CE2_ATP_TST_ECC_Acceptance_ECDSA_IntegratedSignVerify(
  FILE *out, int TST_KeyGeneration_TestStatus)
{
  CE2Error_t TST_TestStatus = 0, error = CE2_OK;
  static     CE2_ECPKI_UserPrivKey_t    TST_UserPrivKey; 
  static     CE2_ECPKI_UserPublKey_t    TST_UserPublKey; 
  int                                    TST_index = 0,TST_KeyGenType;
  char       TST_MasterTestName[TST_FUNC_STRING_LEN] = "CE2_ATP_TST_ECC_Acceptance_ECDSA_SignVerify"; 

  PrintTestBeginMsg(out, __FUNCTION__);

  /* Setting if to use internal key generation */
  if (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)
    TST_KeyGenType = TST_EXTERNAL_KEYPAIR;
  else
    TST_KeyGenType = TST_INTERNAL_KG;

  for (; TST_KeyGenType <2 ; TST_KeyGenType++) /*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/ 
  {
    for (TST_index =0 ; TST_index < TST_NumberOf_ECC_SignVerifyAcceptanceTests ; TST_index++) /*To run on all test vectors*/
    {
      if (TST_KeyGenType == TST_INTERNAL_KG) 
      {
        /* Generating the ECC key Pair */
        /*-----------------------------*/
        error = CE2_ECPKI_GenKeyPair(TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_CE2_ECPKI_DomainID,   
          &TST_UserPrivKey,
          &TST_UserPublKey);
        if (error != CE2_OK) {
          fprintf(out, "Can't generate key pair.");
          fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_Name, TST_index);  
          TST_TestStatus |= error;
          continue;
        }
      }
      else
      {
        /* Building the ECC public Key */
        /*-----------------------------*/
        error = CE2_ECPKI_BuildPublKey(TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_CE2_ECPKI_DomainID,			
          TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPublKey,
          TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPublKeySize,
          &TST_UserPublKey); 
        if (error != CE2_OK) {
          fprintf(out, "Can't build public key.");
          fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_Name, TST_index);  
          TST_TestStatus |= error;
          continue;
        }

        /* Building the ECC private Key */
        /*------------------------------*/
        error = CE2_ECPKI_BuildPrivKey(TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_CE2_ECPKI_DomainID,   
          TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPrivKey,
          TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPrivKeySize,
          &TST_UserPrivKey);
        if (error != CE2_OK) {
          fprintf(out, "Can't build private key.");
          fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_Name, TST_index);  
          TST_TestStatus |= error;
          continue;
        }
      }

      /* Performing the Sign operation */
      /*-------------------------------*/
      error = CE2_ECDSA_Sign(&TST_UserPrivKey,
        TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_HashMode,                
        TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_input_data,      
        TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_input_dataSize,
        TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_output_signiture,
        &TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_SignitureSize );
      if (error != CE2_OK) {
        fprintf(out, "Can't sign.");
        fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_Name, TST_index);  
        TST_TestStatus |= error;
        continue;
      }

      /* Verify the data using the public Key */
      /*--------------------------------------*/
      error = CE2_ECDSA_Verify(&TST_UserPublKey,
        TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_HashMode,
        TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_output_signiture,
        TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_SignitureSize,
        TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_input_data, 
        TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_input_dataSize);
      if (error != CE2_OK) {
        TST_TestStatus |= error;
        fprintf(out, "Can't verify.");
        fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_Name, TST_index);  
        continue;
      }
    }/*End of TST_Index loop*/
  }/* End of TST_KeyGenType loop*/

  PrintTestEndMsg(out, __FUNCTION__, TST_TestStatus);

    return TST_TestStatus;
}/*End of CE2_ATP_TST_ECC_Acceptance_ECDSA_IntegratedSignVerify*/

/*********************************************************
* Function Name:                                                           
*  CE2_ATP_TST_ECC_Acceptance_DH        
* 
* Inputs:
*  None
*
* Outputs:
*  CE2Error_t - Function error return                                     
*
* Description:                                                                      
* To test the Diffie-Hellman key shared secret generation using ECC capabilities
* Algorithm: 
* 1.Build or generate the private and public keys for user 1 using       
*     a. Generate keys 
*     or
*     a. Build the Private Key 
*     b. Build the Public Key 
* 2.Build or generate the private and public keys for user 2 using 
*     a. Generate keys 
*     or
*     a. Build the Private Key 
*     b. Build the Public Key 
* 3. Call CE2_ECDH_SVDP_DH  to Create a shared secret 1 for user 1 
*    using user1 private key and user 2 public key 
* 4. Call CE2_ECDH_SVDP_DH  to Create a shared secret 2 for user 2 
*    using user2 private key and user 1 public key
* 5. Compare the two secret keys - to verify they are identical
*
******************************************************************************/                                          
CE2Error_t CE2_ATP_TST_ECC_Acceptance_DH  (FILE *out, int TST_KeyGeneration_TestStatus)
{
  CE2Error_t TST_TestStatus = 0, error = CE2_OK;
  static     CE2_ECPKI_UserPrivKey_t    TST_UserPrivKey1,TST_UserPrivKey2; 
  static     CE2_ECPKI_UserPublKey_t    TST_UserPublKey1,TST_UserPublKey2; 
  int                                    TST_index = 0, TST_KeyGenType;
  DxUint8_t                              TST_ShareSecret1[TST_DH_MAX_SECRET_LEN_BYTE];
  DxUint8_t                              TST_ShareSecret2[TST_DH_MAX_SECRET_LEN_BYTE];
  DxUint32_t                             TST_ShareSecret1Size,TST_ShareSecret2Size;
  char       TST_MasterTestName[TST_FUNC_STRING_LEN] = "CE2_ATP_TST_ECC_Acceptance_ECDSA_SignVerify"; 
  int cmp_result = 0;

  PrintTestBeginMsg(out, __FUNCTION__);

  /* Setting if to use internal key generation */
  if (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)
    TST_KeyGenType = TST_EXTERNAL_KEYPAIR;
  else
    TST_KeyGenType = TST_INTERNAL_KG;
  for (; TST_KeyGenType <2 ; TST_KeyGenType++) /*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/ 
  {
    for (TST_index =0 ; TST_index < TST_NumberOf_ECC_DHAcceptanceTests ; TST_index++) /*To run on all test vectors*/
    {
      /*Test Data initialization */
      /*-------------------------*/
      TST_ShareSecret1Size = sizeof(TST_ShareSecret1);
      TST_ShareSecret2Size = sizeof(TST_ShareSecret2);
      if (TST_KeyGenType == TST_INTERNAL_KG) 
      {
        /* Generating the ECC key Pair for user 1*/
        /*---------------------------------------*/
        error = CE2_ECPKI_GenKeyPair(TST_ECC_Acceptance_DH_TestData[TST_index].TST_CE2_ECPKI_DomainID,   
          &TST_UserPrivKey1,
          &TST_UserPublKey1);
        if (error != CE2_OK) {
          fprintf(out, "Can't generate key pair 1.");
          fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_DH_TestData[TST_index].TST_Name, TST_index);  
          TST_TestStatus |= error;
          continue;
        }

        /* Generating the ECC key Pair for user 2*/
        /*---------------------------------------*/
        error = CE2_ECPKI_GenKeyPair(TST_ECC_Acceptance_DH_TestData[TST_index].TST_CE2_ECPKI_DomainID,   
          &TST_UserPrivKey2,
          &TST_UserPublKey2);
        if (error != CE2_OK) {
          fprintf(out, "Can't generate key pair 2.");
          fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_DH_TestData[TST_index].TST_Name, TST_index);  
          TST_TestStatus |= error;
          continue;
        }
      }
      else
      {
        /* Building the ECC public Key for user 1 */
        /*-----------------------------------------*/
        error = CE2_ECPKI_BuildPublKey(TST_ECC_Acceptance_DH_TestData[TST_index].TST_CE2_ECPKI_DomainID,			
          TST_ECC_Acceptance_DH_TestData[TST_index].TST_ExternalPublKey1,
          TST_ECC_Acceptance_DH_TestData[TST_index].TST_ExternalPublKey1Size,
          &TST_UserPublKey1); 
        if (error != CE2_OK) {
          fprintf(out, "Can't build public key 1.");
          fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_DH_TestData[TST_index].TST_Name, TST_index);  
          TST_TestStatus |= error;
          continue;
        }

        /* Building the ECC public Key for user 2 */
        /*-----------------------------------------*/
        error = CE2_ECPKI_BuildPublKey(TST_ECC_Acceptance_DH_TestData[TST_index].TST_CE2_ECPKI_DomainID,			
          TST_ECC_Acceptance_DH_TestData[TST_index].TST_ExternalPublKey2,
          TST_ECC_Acceptance_DH_TestData[TST_index].TST_ExternalPublKey2Size,
          &TST_UserPublKey2); 
        if (error != CE2_OK) {
          fprintf(out, "Can't build public key 2.");
          fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_DH_TestData[TST_index].TST_Name, TST_index);  
          TST_TestStatus |= error;
          continue;
        }


        /* Building the ECC private Key for user 1 */
        /*-----------------------------------------*/
        error = CE2_ECPKI_BuildPrivKey(TST_ECC_Acceptance_DH_TestData[TST_index].TST_CE2_ECPKI_DomainID,   
          TST_ECC_Acceptance_DH_TestData[TST_index].TST_ExternalPrivKey1,
          TST_ECC_Acceptance_DH_TestData[TST_index].TST_ExternalPrivKey1Size,
          &TST_UserPrivKey1);
        if (error != CE2_OK) {
          fprintf(out, "Can't build private key 1.");
          fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_DH_TestData[TST_index].TST_Name, TST_index);  
          TST_TestStatus |= error;
          continue;
        }

        /* Building the ECC private Key for user 2 */
        /*-----------------------------------------*/
        error = CE2_ECPKI_BuildPrivKey(TST_ECC_Acceptance_DH_TestData[TST_index].TST_CE2_ECPKI_DomainID,   
          TST_ECC_Acceptance_DH_TestData[TST_index].TST_ExternalPrivKey2,
          TST_ECC_Acceptance_DH_TestData[TST_index].TST_ExternalPrivKey2Size,
          &TST_UserPrivKey2);
        if (error != CE2_OK) {
          fprintf(out, "Can't build private key 2.");
          fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_DH_TestData[TST_index].TST_Name, TST_index);  
          TST_TestStatus |= error;
          continue;
        }
      }

      /* Generating the Secret for user 1*/
      /*---------------------------------*/
      error = CE2_ECDH_SVDP_DH(&TST_UserPublKey2,
        &TST_UserPrivKey1,
        TST_ShareSecret1,
        &TST_ShareSecret1Size);
      if (error != CE2_OK) {
        fprintf(out, "Can't generate shared secret 1.");
        fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_DH_TestData[TST_index].TST_Name, TST_index);  
        TST_TestStatus |= error;
        continue;
      }

      /* Generating the Secret for user 2*/
      /*---------------------------------*/
      error = CE2_ECDH_SVDP_DH(&TST_UserPublKey1,
        &TST_UserPrivKey2,
        TST_ShareSecret2,
        &TST_ShareSecret2Size);
      if (error != CE2_OK) {
        fprintf(out, "Can't generate shared secret 2.");
        fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_DH_TestData[TST_index].TST_Name, TST_index);  
        TST_TestStatus |= error;
        continue;
      }

      /* Verifying we have the same Secret Key both for client & Server */
      /*----------------------------------------------------------------*/                                                    
      cmp_result = memcmp(TST_ShareSecret1,
        TST_ShareSecret2,
        TST_ShareSecret2Size);
      if (cmp_result != 0) {
        fprintf(out, "Shared secrets are different!");
        fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_DH_TestData[TST_index].TST_Name, TST_index);  
        TST_TestStatus |= error;
        continue;
      }

    }/*End of TST_Index loop*/
  }/* End of TST_KeyGenType loop*/

  PrintTestEndMsg(out, __FUNCTION__, TST_TestStatus);

  return TST_TestStatus;
}/*End of CE2_ATP_TST_ECC_Acceptance_DH*/

/*********************************************************
* Function Name:                                                           
*  CE2_ATP_TST_ECC_Acceptance_ElGamal_EncDec        
* 
* Inputs:
*  None
*
* Outputs:
*  CE2Error_t - Function error return                                     
*
* Description:                                                                      
* To test the El-Gamal algorithm for encryption and decryption
*
* Algorithm:      
*  1. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key 
*     b. Build the Public Key 
* 2. Encrypt a block of data using the CE2_ECPKI_ELGAMAL_Encrypt encryption process
* 3. Decrypt a block of data using CE2_ECPKI_ELGAMAL_Decrypt decryption process 
* 4. Compare the decrypted data to the original data
*
******************************************************************************/                                          
CE2Error_t CE2_ATP_TST_ECC_Acceptance_ElGamal_EncDec (FILE *out,  int TST_KeyGeneration_TestStatus)
{
  CE2Error_t TST_TestStatus = 0, error = CE2_OK;
  static     CE2_ECPKI_UserPrivKey_t    TST_UserPrivKey; 
  static     CE2_ECPKI_UserPublKey_t    TST_UserPublKey; 
  int                                   TST_index = 0,TST_KeyGenType;
  char       TST_MasterTestName[TST_FUNC_STRING_LEN] = "CE2_ATP_TST_ECC_Acceptance_ElGamal_EncDec"; 
  int cmp_result = 0;
  DxUint32_t planDataSize;

  PrintTestBeginMsg(out, __FUNCTION__);

  /* Setting if to use internal key generation */
  if (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)
    TST_KeyGenType = TST_EXTERNAL_KEYPAIR;
  else
    TST_KeyGenType = TST_INTERNAL_KG;

  for (; TST_KeyGenType <2 ; TST_KeyGenType++) /*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/ 
  {
    for (TST_index =0 ; TST_index < TST_NumberOf_ECC_ElGamalAcceptanceTests ; TST_index++) /*To run on all test vectors*/
    {

      if (TST_KeyGenType == TST_INTERNAL_KG) 
      {
        /* Generating the ECC key Pair */
        /*-----------------------------*/
        error = CE2_ECPKI_GenKeyPair(TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_CE2_ECPKI_DomainID,   
          &TST_UserPrivKey,
          &TST_UserPublKey);
        if (error != CE2_OK) {
          fprintf(out, "Can't generate key pair.");
          fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_Name, TST_index);  
          TST_TestStatus |= error;
          continue;
        }

      }
      else
      {
        /* Building the ECC public Key */
        /*-----------------------------*/
        error = CE2_ECPKI_BuildPublKey(TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_CE2_ECPKI_DomainID,			
          TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_ExternalPublKey,
          TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_ExternalPublKeySize,
          &TST_UserPublKey); 
        if (error != CE2_OK) {
          fprintf(out, "Can't build public key.");
          fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_Name, TST_index);  
          TST_TestStatus |= error;
          continue;
        }

        /* Building the ECC private Key */
        /*------------------------------*/
        error = CE2_ECPKI_BuildPrivKey(TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_CE2_ECPKI_DomainID,   
          TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_ExternalPrivKey,
          TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_ExternalPrivKeySize,
          &TST_UserPrivKey);
        if (error != CE2_OK) {
          fprintf(out, "Can't build private key.");
          fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_Name, TST_index);  
          TST_TestStatus |= error;
          continue;
        }

      }
      /* Encrypting the massage */
      /*------------------------*/
      error =  CE2_ECPKI_ELGAMAL_Encrypt(&TST_UserPublKey,
        TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_input_data,
        TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_input_dataSize,
        TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_output_data,
        &TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_output_dataSize);
      if (error != CE2_OK) {
        fprintf(out, "Can't make ElGamal encryption.");
        fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_Name, TST_index);  
        TST_TestStatus |= error;
        continue;
      }

      planDataSize = TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_input_dataSize;
      /* Decrypting the massage */
      /*------------------------*/
      error =  CE2_ECPKI_ELGAMAL_Decrypt(&TST_UserPrivKey,
        TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_output_data,
        TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_output_dataSize,
        TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_Decrypted_data,
        &planDataSize);
      if (error != CE2_OK) {
        fprintf(out, "Can't make ElGamal decryption.");
        fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_Name, TST_index);  
        TST_TestStatus |= error;
        continue;
      }

      /* Comparing the decrypted data to the original  */
      /*-----------------------------------------------*/                                                    
      cmp_result = memcmp(TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_Decrypted_data,
        TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_input_data,
        TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_input_dataSize);   
      if (cmp_result != 0) {
        fprintf(out, "Decrypted and original data are different!");
        fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ElGamal_EncDec_TestData[TST_index].TST_Name, TST_index);  
        TST_TestStatus |= error;
        continue;
      }
    }/*End of TST_Index loop*/
  }/* End of TST_KeyGenType loop*/

  PrintTestEndMsg(out, __FUNCTION__, TST_TestStatus);

  return TST_TestStatus;
}/*End of CE2_ATP_TST_ECC_Acceptance_ElGamal_EncDec*/

/*********************************************************
* Function Name:                                                           
*  CE2_ATP_TST_ECC_Acceptance_ImportExportKeyPair        
* 
* Inputs:
*  None
*
* Outputs:
*  CE2Error_t - Function error return                                     
*
* Description:                                                                      
* To test the ECC export public key functionality
*
* Algorithm:      
*  1. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key 
*     b. Build the Public Key 
*  2.	Export the public key using CE2_ECPKI_ExportPublKey
*  3.	Re-build the exported key using CE2_ECPKI_Build_PubKey
*  4.	Sign a massage using the exported public key using CE2_ECDSA_Sign to perform the sign operation
*  5.	Verify the massage using the appropriate public key using CE2_ECDSA_Verify
*      to perform the verification operation
*
******************************************************************************/                                          
CE2Error_t CE2_ATP_TST_ECC_Acceptance_ImportExportKeyPair(FILE *out,  int TST_KeyGeneration_TestStatus)
{
  CE2Error_t TST_TestStatus = 0, error = CE2_OK;
  static     CE2_ECPKI_UserPrivKey_t               TST_UserPrivKey; 
  static     CE2_ECPKI_UserPublKey_t               TST_UserPublKey; 
  static     CE2_ECPKI_UserPublKey_t               TST_UserPublKeyExported; 
  DxUint8_t  TST_UserPublKeyExported_buff[TST_MAX_ECC_KEY_SIZE_BYTES]; 
  DxUint8_t  TST_UserPrivKeyExported_buff[TST_MAX_ECC_KEY_SIZE_BYTES]; 
  DxUint32_t TST_UserPublKeyExported_buffSize;
  DxUint32_t TST_UserPrivKeyExported_buffSize;
  int        TST_index = 0,TST_KeyGenType;
  char       TST_MasterTestName[TST_FUNC_STRING_LEN] = "CE2_ATP_TST_ECC_Acceptance_ElGamal_EncDec"; 

  PrintTestBeginMsg(out, __FUNCTION__);

  /* Setting if to use internal key generation */
  if (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)
    TST_KeyGenType = TST_EXTERNAL_KEYPAIR;
  else
    TST_KeyGenType = TST_INTERNAL_KG;

  for (; TST_KeyGenType <2 ; TST_KeyGenType++) /*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/ 
  {
    for (TST_index =0 ; TST_index < TST_NumberOf_ECC_SignVerifyAcceptanceTests ; TST_index++) /*To run on all test vectors*/
    {

      /*Initializing the data*/
      TST_UserPublKeyExported_buffSize = TST_MAX_ECC_KEY_SIZE_BYTES;

      if (TST_KeyGenType == TST_INTERNAL_KG) 
      {
        /* Generating the ECC key Pair */
        /*-----------------------------*/
        error = CE2_ECPKI_GenKeyPair(TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_CE2_ECPKI_DomainID,   
          &TST_UserPrivKey,
          &TST_UserPublKey);
        if (error != CE2_OK) {
          fprintf(out, "Can't generate key pair.");
          fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_Name, TST_index);  
          TST_TestStatus |= error;
          continue;
        }

      }
      else
      {
        /* Building the ECC public Key */
        /*-----------------------------*/
        error = CE2_ECPKI_BuildPublKey(TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_CE2_ECPKI_DomainID,			
          TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPublKey,
          TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPublKeySize,
          &TST_UserPublKey); 
        if (error != CE2_OK) {
          fprintf(out, "Can't build public key.");
          fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_Name, TST_index);  
          TST_TestStatus |= error;
          continue;
        }

        /* Building the ECC private Key */
        /*------------------------------*/
        error = CE2_ECPKI_BuildPrivKey(TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_CE2_ECPKI_DomainID,   
          TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPrivKey,
          TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPrivKeySize,
          &TST_UserPrivKey);
        if (error != CE2_OK) {
          fprintf(out, "Can't build private key.");
          fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_Name, TST_index);  
          TST_TestStatus |= error;
          continue;
        }

        /* Export the ECC private Key */
        /*------------------------------*/
        TST_UserPrivKeyExported_buffSize = TST_MAX_ECC_KEY_SIZE_BYTES;
        error = CE2_ECPKI_ExportPrivKey(&TST_UserPrivKey, 
          TST_UserPrivKeyExported_buff, &TST_UserPrivKeyExported_buffSize);
        if (error != CE2_OK) {
          fprintf(out, "Can't export private key.");
          fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_Name, TST_index);  
          TST_TestStatus |= error;
          continue;
        }
        if (TST_UserPrivKeyExported_buffSize != 
          TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPrivKeySize) {
            fprintf(out, "Wrong export private key size.");
            fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_Name, TST_index);  
            TST_TestStatus |= error;
            continue;
        }
        if (memcmp(TST_UserPrivKeyExported_buff, 
          TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_ExternalPrivKey,
          TST_UserPrivKeyExported_buffSize) != 0) {
            fprintf(out, "Wrong export private key.");
            fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_Name, TST_index);  
            TST_TestStatus |= error;
            continue;
        }
      }
      /* Export the public key the massage */
      /*-----------------------------------*/
      error =  CE2_ECPKI_ExportPublKey(&TST_UserPublKey,
        CE2_EC_PointUncompressed,
        TST_UserPublKeyExported_buff,
        &TST_UserPublKeyExported_buffSize); 
      if (error != CE2_OK) {
        fprintf(out, "Can't export public key.");
        fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_Name, TST_index);  
        TST_TestStatus |= error;
        continue;
      }
      /*Import the exported key to a different pubkey*/
      /*---------------------------------------------*/
      error = CE2_ECPKI_BuildPublKey(TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_CE2_ECPKI_DomainID,			
        TST_UserPublKeyExported_buff,
        TST_UserPublKeyExported_buffSize,
        &TST_UserPublKeyExported); 
      if (error != CE2_OK) {
        fprintf(out, "Can't build public key 2.");
        fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_Name, TST_index);  
        TST_TestStatus |= error;
        continue;
      }

      /* Performing the Sign operation */
      /*-------------------------------*/
      error = CE2_ECDSA_Sign(&TST_UserPrivKey,
        TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_HashMode,                
        TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_input_data,      
        TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_input_dataSize,
        TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_output_signiture,
        &TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_SignitureSize );
      if (error != CE2_OK) {
        fprintf(out, "Can't sign.");
        fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_Name, TST_index);  
        TST_TestStatus |= error;
        continue;
      }

      /* Verify the data using the exported public Key */
      /*-----------------------------------------------*/
      error = CE2_ECDSA_Verify(&TST_UserPublKeyExported,
        TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_HashMode,
        TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_output_signiture,
        TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_SignitureSize,
        TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_input_data, 
        TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_input_dataSize);
      if (error != CE2_OK) {
        fprintf(out, "Can't verify.");
        fprintf(out, " %s[test 1.%d]\n", TST_ECC_Acceptance_ECDSA_SignVerify_TestData[TST_index].TST_Name, TST_index);  
        TST_TestStatus |= error;
        continue;
      }
    }/*End of TST_Index loop*/
  }/* End of TST_KeyGenType loop*/

  PrintTestEndMsg(out, __FUNCTION__, TST_TestStatus);

  return TST_TestStatus;
}/*End of CE2_ATP_TST_ECC_Acceptance_ImportExportKeyPair*/
